
/**
 ******************************************************************************
 *
 * @file      ARGB_MG04_06.h
 * @brief     The code is using ASB of APX to control ARGB
 *
 * @par       Project
 *            MG32
 * @version   V1.01
 * @date      2022/08/01
 * @author    Megawin Software Center
 * @copyright Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *            All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef __ARGB_MG04_06_H
#define __ARGB_MG04_06_H
 

#include "MG32__Common_DRV.h"
#include "MG32_APX_DRV.h"
#include "MG32_DMA_DRV.h"
#include "BSP_Common_MG04_06.h"
#include "MG32_GPIO_DRV.h"
#include "MG32_APX_DRV.h"

/** 
 * @name  define
 */
///@{

/*GPIO define*/
#define ASB_P0_IOM_PIN            PINA(8)
#define ASB_P0_IOM_AFS            2
                                  
                                  
/*ARGB ASCII */               
#define ASCII_TOTAL_TABLE         ( 1 + 10 + 26 + 26)
#define ASCII_ROW                 7
#define ASCII_COLUM               6

#define ARGB_STRING_SPACE_SHIFT   0
#define ARGB_STRING_0_SHIFT       1
#define ARGB_STRING_A_SHIFT       11
#define ARGB_STRING_a_SHIFT       37


#define ARGB_STRING_SPACE_ASCII   0x20
#define ARGB_STRING_0_ASCII       0x30
#define ARGB_STRING_A_ASCII       0x41
#define ARGB_STRING_a_ASCII       0x61


/*ARGB array */
#define ARGB_ROW                  6
#define ARGB_COLUMN               8
                                  
                                  
#define ARGB_TOTAL_PIECE          (ARGB_ROW * ARGB_COLUMN)
#define ARGB_PIECE_PIXEL          3    
#define ARGB_TOTAL_BYTE           (ARGB_TOTAL_PIECE * ARGB_PIECE_PIXEL)
                


/*ARGB control status*/
#define ARGB_STATUE_IDLE          0x00
#define ARGB_STATUS_DATAREADY     0x01
#define ARGB_STATUS_TXBUSY        0x02 


/*ASB define*/
#define ARGB_TXFLAG               APX_ASB0_TXF
#define ARGB_TCFLAG               APX_ASB0_TCF
                                  
#define ARGB_TXIE                 APX_ASB0_TIE
#define ARGB_TCIE                 APX_ASB0_TCIE
                                  
#define ARGB_ASBChannel           0  


/*ARGB data format*/
#define ARGB_G_Color              0
#define ARGB_R_Color              1
#define ARGB_B_Color              2

/*Built-in colors */
#define ARGB_Default_Color        7


/*ARGB string buffer size*/
#define ARGB_STRING_MAX           48


         
/*ARGB Mode*/
#define ARGB_ACT_MASK             0x80000000
#define ARGB_MODE_MASK            0x0000FF00
#define ARGB_SMODE_MASK           0x000000FF


#define ARGB_MODE_TOTAL           5
#define ARGB_MODE_DISABLE         0x000
#define ARGB_MODE_SINGLE_COLOR    0x100
#define ARGB_MODE_CROSS           0x200
#define ARGB_MODE_NET             0x300
#define ARGB_MODE_STRING          0x400
#define ARGB_MODE_SHIFT           8


#define ARGB_MODE_INC             0x100
#define ARGB_SMOD_INC             0x1

///@}

/**
 * @name  typedef
 */
///@{


/*! @struct ARGBCTR_TypeDef
    @brief  ARGB control 
*/
typedef struct
{
    uint32_t         DataCount;                 /*ASB already transmit data size.*/
    uint8_t          TXBuf[ARGB_TOTAL_BYTE];    /*ARGB transmit data buffer*/
                     
    uint32_t         DramaMode;                 /*ARGB mode*/
    uint8_t*         DramaBuf;                  /*ARGB Drama buffer pointer*/
                     
    uint32_t         DramaCount;                /*time counter*/                  
    uint32_t         DramaCountCompare;         /*Control ARGB speed*/
    
    uint8_t          DramaMainCount;            /*Main step counter*/
    uint8_t          DramaSubCount;             /*Sub step counter*/
    uint8_t          DramaMainCompare;          /*total main step in the ARGB mode.*/
    uint8_t          DramaSubCompare;           /*total sub. step in the ARGB mode.*/
                     
    uint8_t          ColorIndex;                /*Color index (control Color0 , Color1)*/
    uint8_t          ColorNumber;               /*Use several color in the ARGB mode */
    uint8_t          R_Color[2];                /*Color Red table*/
    uint8_t          G_Color[2];                /*Color Green table*/
    uint8_t          B_Color[2];                /*Color Blue table*/
    
    FunctionalState  loop;                      /*ARGB loop control*/
    uint8_t          Status;                    /*ARGB status*/
    uint8_t          __padding[2];                          
}ARGBCTR_TypeDef;

///@}


/**
 * @name  vairables
 */
///@{

extern ARGBCTR_TypeDef  ARGB_CTR;
extern uint8_t ARGB_DefaultColor[ARGB_Default_Color*3];
extern uint8_t const ARGB_StringTable[ ASCII_TOTAL_TABLE * ( ASCII_ROW * ASCII_COLUM) ];
extern uint8_t const ARGB_Table[ARGB_COLUMN][ARGB_ROW];
///@}

/**
 * @name  function
 */
///@{
void BSP_ASB_IRQHandle(void);
void BSP_ARGB_Init(void);
void BSP_ARGB_ChangeColor( uint8_t ARGBColor_Index, uint8_t ARGBColor_R , uint8_t ARGBColor_G, uint8_t ARGBColor_B);
void BSP_ARGB_ChangeDrama(uint32_t ARGB_ChDrameMode , FunctionalState ARGB_LOOP);
void BSP_ARGB_Drama(void);
void BSP_ARGB_DataUpdate(void);
void BSP_ARGB_InitCallback(void);
///@}


#endif


